/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.recipes.crafting.recipes;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.recipes.crafting.VerticalSlabCraftingRecipe;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class VerticalSlabToBlockCraftingRecipe
extends VerticalSlabCraftingRecipe {
    public static final String ID = "vertical_slab_to_block_crafting_recipe";
    private static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("vertical_slab_to_block_crafting_recipe");

    public VerticalSlabToBlockCraftingRecipe() {
        super(2, 1);
    }

    @Override
    @Nonnull
    public ItemStack assemble(@Nonnull ItemStack matchedItem) {
        return ((Item)VerticalSlabUtils.MapsManager.slabMap.get((Object)VerticalSlabUtils.getReferredSlabState(matchedItem).m_60734_().m_5456_())).m_7968_();
    }

    public ResourceLocation m_6423_() {
        return RESOURCE_LOCATION;
    }

    public Serializer getSerializer() {
        return (Serializer)JustVerticalSlabsLoader.VERTICAL_SLAB_TO_BLOCK_CRAFTING_RECIPE_SERIALIZER.get();
    }

    @Override
    protected Integer getMatchIndex(CraftingContainer craftingContainer) {
        boolean correctPattern = true;
        Integer matchIndex = null;
        Integer containerWidth = craftingContainer.m_39347_();
        for (int h = 0; h < containerWidth && correctPattern; ++h) {
            for (int w = 0; w < craftingContainer.m_39346_() && correctPattern; ++w) {
                int index = w + h * containerWidth;
                ItemStack itemStack1 = craftingContainer.m_8020_(index);
                if (itemStack1.m_41619_()) continue;
                if (this.isVerticalSlab(itemStack1)) {
                    ItemStack itemStack2 = craftingContainer.m_8020_(index + 1);
                    if (this.isVerticalSlab(itemStack2)) {
                        if (matchIndex == null && (index + 1) % containerWidth != 0 && this.verticalSlabsMatch(itemStack1, itemStack2)) {
                            matchIndex = index;
                            continue;
                        }
                        matchIndex = null;
                        correctPattern = false;
                        continue;
                    }
                    if (matchIndex != null && matchIndex == index - 1) continue;
                    matchIndex = null;
                    correctPattern = false;
                    continue;
                }
                matchIndex = null;
                correctPattern = false;
            }
        }
        return matchIndex;
    }

    protected boolean verticalSlabsMatch(ItemStack itemStack1, ItemStack itemStack2) {
        return VerticalSlabUtils.getReferredSlabState(itemStack1) == VerticalSlabUtils.getReferredSlabState(itemStack2) && VerticalSlabUtils.MapsManager.slabMap.containsKey((Object)VerticalSlabUtils.getReferredSlabState(itemStack1).m_60734_().m_5456_());
    }

    public static class Serializer
    extends VerticalSlabCraftingRecipe.Serializer<VerticalSlabToBlockCraftingRecipe> {
        public static final String ID = "vertical_slab_to_block_crafting_recipe_serializer";
        public static final ResourceLocation RESOURCE_LOCATION = VerticalSlabUtils.getResourceLocation("vertical_slab_to_block_crafting_recipe_serializer");

        public Serializer() {
            super(VerticalSlabToBlockCraftingRecipe::new);
        }
    }
}

